
SELECT * FROM TAB_FATURAMENTO;

CREATE MATERIALIZED VIEW USER13.VIEW_TAB_FATURAMENTO
REFRESH FORCE WITH ROWID
ENABLE QUERY REWRITE
AS
SELECT NOTAS_FISCAIS.DATA_VENDA, SUM(ITENS_NOTAS_FISCAIS.QUANTIDADE * ITENS_NOTAS_FISCAIS.PRECO) AS TOTAL_VENDA
FROM NOTAS_FISCAIS INNER JOIN ITENS_NOTAS_FISCAIS
ON NOTAS_FISCAIS.NUMERO = ITENS_NOTAS_FISCAIS.NUMERO
GROUP BY NOTAS_FISCAIS.DATA_VENDA;

begin
  dbms_stats.gather_table_stats('"USER13"','"VIEW_TAB_FATURAMENTO"',NULL,dbms_stats.auto_sample_size);
end;

INSERT INTO NOTAS_FISCAIS VALUES ('50534475787','00236',TO_DATE('2018-04-01','YYYY-MM-DD'),10000004,0.12,6311,'Atacado');
INSERT INTO ITENS_NOTAS_FISCAIS VALUES (10000004, '1013793', 63, 24.01);
INSERT INTO ITENS_NOTAS_FISCAIS VALUES (10000004, '1101035', 26, 9.0105);


